/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum InputPromptControlStyle implements Enumerator
{
    TEXT_FIELD_LITERAL(0, "TextField", "TextField"),
    SELECTABLE_LIST_LITERAL(1, "SelectableList", "SelectableList"),
    SELECTABLE_LIST_WITH_TEXT_FIELD_LITERAL(2, "SelectableListWithTextField", "SelectableListWithTextField"),
    CHECK_BOX_LITERAL(3, "CheckBox", "CheckBox"),
    RADIO_BUTTON_LITERAL(4, "RadioButton", "RadioButton");

    public static final String copyright = "Copyright (c) 2005, 2009 Actuate Corporation";
    public static final int TEXT_FIELD = 0;
    public static final int SELECTABLE_LIST = 1;
    public static final int SELECTABLE_LIST_WITH_TEXT_FIELD = 2;
    public static final int CHECK_BOX = 3;
    public static final int RADIO_BUTTON = 4;
    private static final InputPromptControlStyle[] VALUES_ARRAY;
    public static final List<InputPromptControlStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new InputPromptControlStyle[]{TEXT_FIELD_LITERAL, SELECTABLE_LIST_LITERAL, SELECTABLE_LIST_WITH_TEXT_FIELD_LITERAL, CHECK_BOX_LITERAL, RADIO_BUTTON_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static InputPromptControlStyle get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InputPromptControlStyle result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InputPromptControlStyle getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InputPromptControlStyle result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InputPromptControlStyle get(int value) {
        switch (value) {
            case 0: {
                return TEXT_FIELD_LITERAL;
            }
            case 1: {
                return SELECTABLE_LIST_LITERAL;
            }
            case 2: {
                return SELECTABLE_LIST_WITH_TEXT_FIELD_LITERAL;
            }
            case 3: {
                return CHECK_BOX_LITERAL;
            }
            case 4: {
                return RADIO_BUTTON_LITERAL;
            }
        }
        return null;
    }

    private InputPromptControlStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

