/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.Group;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="META_VIEW")
public class MetaView
extends AuditableModel {
    @NotNull
    @Index(name="META_VIEW_NAME_IDX")
    private String name;
    @NameColumn
    @NotNull
    @Index(name="META_VIEW_TITLE_IDX")
    private String title;
    @Widget(selection="view.type.selection")
    @NotNull
    private String type;
    @NotNull
    private Integer priority = 20;
    private String model;
    private String module;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    @NotNull
    private String xml;
    @HashKey
    @Column(unique=true)
    private String xmlId;
    private String helpLink;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Group> groups;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="META_VIEW_SEQ")
    @SequenceGenerator(name="META_VIEW_SEQ", sequenceName="META_VIEW_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Remove view")
    private Boolean removeView = Boolean.FALSE;

    public MetaView() {
    }

    public MetaView(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getXml() {
        return this.xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public String getXmlId() {
        return this.xmlId;
    }

    public void setXmlId(String xmlId) {
        this.xmlId = xmlId;
    }

    public String getHelpLink() {
        return this.helpLink;
    }

    public void setHelpLink(String helpLink) {
        this.helpLink = helpLink;
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<Group> groups) {
        this.groups = groups;
    }

    public void addGroup(Group item) {
        if (this.groups == null) {
            this.groups = new HashSet<Group>();
        }
        this.groups.add(item);
    }

    public void removeGroup(Group item) {
        if (this.groups == null) {
            return;
        }
        this.groups.remove(item);
    }

    public void clearGroups() {
        if (this.groups != null) {
            this.groups.clear();
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean getRemoveView() {
        return this.removeView == null ? Boolean.FALSE : this.removeView;
    }

    public void setRemoveView(Boolean removeView) {
        this.removeView = removeView;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaView)) {
            return false;
        }
        MetaView other = (MetaView)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getXmlId(), other.getXmlId());
    }

    public int hashCode() {
        return Objects.hash(-385769878, this.getXmlId());
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("name", (Object)this.getName());
        tsh.add("title", (Object)this.getTitle());
        tsh.add("type", (Object)this.getType());
        tsh.add("priority", (Object)this.getPriority());
        tsh.add("model", (Object)this.getModel());
        tsh.add("module", (Object)this.getModule());
        tsh.add("xmlId", (Object)this.getXmlId());
        tsh.add("helpLink", (Object)this.getHelpLink());
        tsh.add("removeView", (Object)this.getRemoveView());
        return tsh.omitNullValues().toString();
    }
}

