/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.db.Model;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="META_TRANSLATION", uniqueConstraints={@UniqueConstraint(columnNames={"message_key", "language"})})
public class MetaTranslation
extends Model {
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    @NotNull
    @Column(name="message_key")
    private String key;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    @Column(name="message_value")
    private String message;
    @NotNull
    private String language;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="META_TRANSLATION_SEQ")
    @SequenceGenerator(name="META_TRANSLATION_SEQ", sequenceName="META_TRANSLATION_SEQ", allocationSize=1)
    private Long id;
    private String module;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaTranslation)) {
            return false;
        }
        MetaTranslation other = (MetaTranslation)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("language", (Object)this.getLanguage());
        tsh.add("module", (Object)this.getModule());
        return tsh.omitNullValues().toString();
    }
}

