/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.MetaModule;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Index;

@Entity
@Table(name="META_SEQUENCE")
public class MetaSequence
extends AuditableModel {
    @HashKey
    @NotNull
    @Size(min=2)
    @Column(unique=true)
    private String name;
    private String prefix;
    private String suffix;
    @NotNull
    private Integer padding = 0;
    @NotNull
    @Column(name="increment_by")
    private Integer increment = 1;
    @NotNull
    @Column(name="initial_value")
    private Long initial = 0L;
    @NotNull
    @Column(name="next_value")
    private Long next = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
    @Index(name="META_SEQUENCE_META_MODEL_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaModel metaModel;
    @Widget(title="Module")
    @Index(name="META_SEQUENCE_META_MODULE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaModule metaModule;

    public MetaSequence() {
    }

    public MetaSequence(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public Integer getPadding() {
        return this.padding == null ? 0 : this.padding;
    }

    public void setPadding(Integer padding) {
        this.padding = padding;
    }

    public Integer getIncrement() {
        return this.increment == null ? 0 : this.increment;
    }

    public void setIncrement(Integer increment) {
        this.increment = increment;
    }

    public Long getInitial() {
        return this.initial == null ? 0L : this.initial;
    }

    public void setInitial(Long initial) {
        this.initial = initial;
    }

    public Long getNext() {
        return this.next == null ? 0L : this.next;
    }

    public void setNext(Long next) {
        this.next = next;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public MetaModel getMetaModel() {
        return this.metaModel;
    }

    public void setMetaModel(MetaModel metaModel) {
        this.metaModel = metaModel;
    }

    public MetaModule getMetaModule() {
        return this.metaModule;
    }

    public void setMetaModule(MetaModule metaModule) {
        this.metaModule = metaModule;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaSequence)) {
            return false;
        }
        MetaSequence other = (MetaSequence)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hash(1110012166, this.getName());
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("name", (Object)this.getName());
        tsh.add("prefix", (Object)this.getPrefix());
        tsh.add("suffix", (Object)this.getSuffix());
        tsh.add("padding", (Object)this.getPadding());
        tsh.add("increment", (Object)this.getIncrement());
        tsh.add("initial", (Object)this.getInitial());
        tsh.add("next", (Object)this.getNext());
        return tsh.omitNullValues().toString();
    }
}

