/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="META_MODULE")
public class MetaModule
extends AuditableModel {
    @HashKey
    @NotNull
    @Column(unique=true)
    private String name;
    @NotNull
    private String title;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String description;
    @Size(max=512)
    private String depends;
    @Widget(title="Version")
    @NotNull
    private String moduleVersion;
    private Boolean removable = Boolean.FALSE;
    private Boolean installed = Boolean.FALSE;
    private Boolean pending = Boolean.FALSE;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="META_MODULE_SEQ")
    @SequenceGenerator(name="META_MODULE_SEQ", sequenceName="META_MODULE_SEQ", allocationSize=1)
    private Long id;
    private Boolean customised = Boolean.FALSE;

    public MetaModule() {
    }

    public MetaModule(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDepends() {
        return this.depends;
    }

    public void setDepends(String depends) {
        this.depends = depends;
    }

    public String getModuleVersion() {
        return this.moduleVersion;
    }

    public void setModuleVersion(String moduleVersion) {
        this.moduleVersion = moduleVersion;
    }

    public Boolean getRemovable() {
        return this.removable == null ? Boolean.FALSE : this.removable;
    }

    public void setRemovable(Boolean removable) {
        this.removable = removable;
    }

    public Boolean getInstalled() {
        return this.installed == null ? Boolean.FALSE : this.installed;
    }

    public void setInstalled(Boolean installed) {
        this.installed = installed;
    }

    public Boolean getPending() {
        return this.pending == null ? Boolean.FALSE : this.pending;
    }

    public void setPending(Boolean pending) {
        this.pending = pending;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean getCustomised() {
        return this.customised == null ? Boolean.FALSE : this.customised;
    }

    public void setCustomised(Boolean customised) {
        this.customised = customised;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaModule)) {
            return false;
        }
        MetaModule other = (MetaModule)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hash(-1609814799, this.getName());
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("name", (Object)this.getName());
        tsh.add("title", (Object)this.getTitle());
        tsh.add("depends", (Object)this.getDepends());
        tsh.add("moduleVersion", (Object)this.getModuleVersion());
        tsh.add("removable", (Object)this.getRemovable());
        tsh.add("installed", (Object)this.getInstalled());
        tsh.add("pending", (Object)this.getPending());
        tsh.add("customised", (Object)this.getCustomised());
        return tsh.omitNullValues().toString();
    }
}

