/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaModule;
import com.axelor.meta.db.MetaSequence;
import com.axelor.studio.db.RightManagement;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Index;

@Entity
@Cacheable
@Table(name="META_MODEL")
public class MetaModel
extends AuditableModel {
    @Widget(title="Name")
    @NotNull
    @Index(name="META_MODEL_NAME_IDX")
    private String name;
    @Widget(title="Package")
    @NotNull
    private String packageName;
    @Widget(title="Table")
    private String tableName;
    @Widget(title="Fields")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="metaModel", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<MetaField> metaFields;
    @Widget(title="Fullname")
    private String fullName;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="META_MODEL_SEQ")
    @SequenceGenerator(name="META_MODEL_SEQ", sequenceName="META_MODEL_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Right management")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="metaModel", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<RightManagement> rightManagementList;
    private Boolean customised = Boolean.FALSE;
    private Boolean edited = Boolean.FALSE;
    @Widget(title="Title")
    private String title;
    @Widget(title="Sequences")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="metaModel", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<MetaSequence> metaSequenceList;
    @Widget(title="Module")
    @Index(name="META_MODEL_META_MODULE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaModule metaModule;

    public MetaModel() {
    }

    public MetaModel(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<MetaField> getMetaFields() {
        return this.metaFields;
    }

    public void setMetaFields(List<MetaField> metaFields) {
        this.metaFields = metaFields;
    }

    public void addMetaField(MetaField item) {
        if (this.metaFields == null) {
            this.metaFields = new ArrayList<MetaField>();
        }
        this.metaFields.add(item);
        item.setMetaModel(this);
    }

    public void removeMetaField(MetaField item) {
        if (this.metaFields == null) {
            return;
        }
        this.metaFields.remove((Object)item);
    }

    public void clearMetaFields() {
        if (this.metaFields != null) {
            this.metaFields.clear();
        }
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<RightManagement> getRightManagementList() {
        return this.rightManagementList;
    }

    public void setRightManagementList(List<RightManagement> rightManagementList) {
        this.rightManagementList = rightManagementList;
    }

    public void addRightManagementListItem(RightManagement item) {
        if (this.rightManagementList == null) {
            this.rightManagementList = new ArrayList<RightManagement>();
        }
        this.rightManagementList.add(item);
        item.setMetaModel(this);
    }

    public void removeRightManagementListItem(RightManagement item) {
        if (this.rightManagementList == null) {
            return;
        }
        this.rightManagementList.remove(item);
    }

    public void clearRightManagementList() {
        if (this.rightManagementList != null) {
            this.rightManagementList.clear();
        }
    }

    public Boolean getCustomised() {
        return this.customised == null ? Boolean.FALSE : this.customised;
    }

    public void setCustomised(Boolean customised) {
        this.customised = customised;
    }

    public Boolean getEdited() {
        return this.edited == null ? Boolean.FALSE : this.edited;
    }

    public void setEdited(Boolean edited) {
        this.edited = edited;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<MetaSequence> getMetaSequenceList() {
        return this.metaSequenceList;
    }

    public void setMetaSequenceList(List<MetaSequence> metaSequenceList) {
        this.metaSequenceList = metaSequenceList;
    }

    public void addMetaSequenceListItem(MetaSequence item) {
        if (this.metaSequenceList == null) {
            this.metaSequenceList = new ArrayList<MetaSequence>();
        }
        this.metaSequenceList.add(item);
        item.setMetaModel(this);
    }

    public void removeMetaSequenceListItem(MetaSequence item) {
        if (this.metaSequenceList == null) {
            return;
        }
        this.metaSequenceList.remove((Object)item);
    }

    public void clearMetaSequenceList() {
        if (this.metaSequenceList != null) {
            this.metaSequenceList.clear();
        }
    }

    public MetaModule getMetaModule() {
        return this.metaModule;
    }

    public void setMetaModule(MetaModule metaModule) {
        this.metaModule = metaModule;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaModel)) {
            return false;
        }
        MetaModel other = (MetaModel)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("name", (Object)this.getName());
        tsh.add("packageName", (Object)this.getPackageName());
        tsh.add("tableName", (Object)this.getTableName());
        tsh.add("fullName", (Object)this.getFullName());
        tsh.add("customised", (Object)this.getCustomised());
        tsh.add("edited", (Object)this.getEdited());
        tsh.add("title", (Object)this.getTitle());
        return tsh.omitNullValues().toString();
    }
}

