/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.Group;
import com.axelor.auth.db.Role;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaAction;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Index;

@Entity
@Cacheable
@Table(name="META_MENU")
public class MetaMenu
extends AuditableModel {
    private Integer priority = 0;
    @Column(name="order_seq")
    private Integer order = 0;
    @HashKey
    @Column(unique=true)
    private String xmlId;
    @NotNull
    @Index(name="META_MENU_NAME_IDX")
    private String name;
    @NameColumn
    @NotNull
    @Index(name="META_MENU_TITLE_IDX")
    private String title;
    private String icon;
    private String iconBackground;
    private String module;
    private String tag;
    private String tagGet;
    private Boolean tagCount = Boolean.FALSE;
    @Widget(selection="label.style.selection")
    private String tagStyle;
    @Column(name="top_menu")
    private Boolean top = Boolean.FALSE;
    @Column(name="left_menu")
    private Boolean left = Boolean.TRUE;
    @Column(name="mobile_menu")
    private Boolean mobile = Boolean.FALSE;
    private Boolean hidden = Boolean.FALSE;
    private String link;
    @Index(name="META_MENU_PARENT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaMenu parent;
    @Index(name="META_MENU_ACTION_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaAction action;
    @Index(name="META_MENU_USER_ID_IDX")
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Group> groups;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Role> roles;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="META_MENU_SEQ")
    @SequenceGenerator(name="META_MENU_SEQ", sequenceName="META_MENU_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Remove menu")
    private Boolean removeMenu = Boolean.FALSE;

    public MetaMenu() {
    }

    public MetaMenu(String name) {
        this.name = name;
    }

    public Integer getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getOrder() {
        return this.order == null ? 0 : this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public String getXmlId() {
        return this.xmlId;
    }

    public void setXmlId(String xmlId) {
        this.xmlId = xmlId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getIconBackground() {
        return this.iconBackground;
    }

    public void setIconBackground(String iconBackground) {
        this.iconBackground = iconBackground;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getTagGet() {
        return this.tagGet;
    }

    public void setTagGet(String tagGet) {
        this.tagGet = tagGet;
    }

    public Boolean getTagCount() {
        return this.tagCount == null ? Boolean.FALSE : this.tagCount;
    }

    public void setTagCount(Boolean tagCount) {
        this.tagCount = tagCount;
    }

    public String getTagStyle() {
        return this.tagStyle;
    }

    public void setTagStyle(String tagStyle) {
        this.tagStyle = tagStyle;
    }

    public Boolean getTop() {
        return this.top == null ? Boolean.FALSE : this.top;
    }

    public void setTop(Boolean top) {
        this.top = top;
    }

    public Boolean getLeft() {
        return this.left == null ? Boolean.FALSE : this.left;
    }

    public void setLeft(Boolean left) {
        this.left = left;
    }

    public Boolean getMobile() {
        return this.mobile == null ? Boolean.FALSE : this.mobile;
    }

    public void setMobile(Boolean mobile) {
        this.mobile = mobile;
    }

    public Boolean getHidden() {
        return this.hidden == null ? Boolean.FALSE : this.hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public MetaMenu getParent() {
        return this.parent;
    }

    public void setParent(MetaMenu parent) {
        this.parent = parent;
    }

    public MetaAction getAction() {
        return this.action;
    }

    public void setAction(MetaAction action) {
        this.action = action;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<Group> groups) {
        this.groups = groups;
    }

    public void addGroup(Group item) {
        if (this.groups == null) {
            this.groups = new HashSet<Group>();
        }
        this.groups.add(item);
    }

    public void removeGroup(Group item) {
        if (this.groups == null) {
            return;
        }
        this.groups.remove(item);
    }

    public void clearGroups() {
        if (this.groups != null) {
            this.groups.clear();
        }
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public void addRole(Role item) {
        if (this.roles == null) {
            this.roles = new HashSet<Role>();
        }
        this.roles.add(item);
    }

    public void removeRole(Role item) {
        if (this.roles == null) {
            return;
        }
        this.roles.remove(item);
    }

    public void clearRoles() {
        if (this.roles != null) {
            this.roles.clear();
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean getRemoveMenu() {
        return this.removeMenu == null ? Boolean.FALSE : this.removeMenu;
    }

    public void setRemoveMenu(Boolean removeMenu) {
        this.removeMenu = removeMenu;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaMenu)) {
            return false;
        }
        MetaMenu other = (MetaMenu)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getXmlId(), other.getXmlId());
    }

    public int hashCode() {
        return Objects.hash(-386041564, this.getXmlId());
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("priority", (Object)this.getPriority());
        tsh.add("order", (Object)this.getOrder());
        tsh.add("xmlId", (Object)this.getXmlId());
        tsh.add("name", (Object)this.getName());
        tsh.add("title", (Object)this.getTitle());
        tsh.add("icon", (Object)this.getIcon());
        tsh.add("iconBackground", (Object)this.getIconBackground());
        tsh.add("module", (Object)this.getModule());
        tsh.add("tag", (Object)this.getTag());
        tsh.add("tagGet", (Object)this.getTagGet());
        tsh.add("tagCount", (Object)this.getTagCount());
        return tsh.omitNullValues().toString();
    }
}

