/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.MetaModule;
import com.axelor.meta.db.MetaSelect;
import com.axelor.studio.db.RightManagement;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="META_FIELD", uniqueConstraints={@UniqueConstraint(columnNames={"name", "meta_model"})})
public class MetaField
extends AuditableModel {
    @Index(name="META_FIELD_META_MODEL_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaModel metaModel;
    @Widget(title="Name")
    @NotNull
    @Index(name="META_FIELD_NAME_IDX")
    private String name;
    @Widget(title="Package")
    private String packageName;
    @Widget(title="Type")
    @NotNull
    private String typeName;
    @Widget(title="Label")
    private String label;
    @Widget(title="Relationship", selection="relationship.field.selection")
    private String relationship;
    @Widget(title="Mapped by")
    private String mappedBy;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String description;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="META_FIELD_SEQ")
    @SequenceGenerator(name="META_FIELD_SEQ", sequenceName="META_FIELD_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Right management")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="metaField", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<RightManagement> rightManagementList;
    @Widget(title="Type", selection="field.type.selection")
    private String fieldType;
    @Widget(title="Default")
    private Boolean defaultBoolean;
    @Widget(title="Default")
    private BigDecimal defaultDecimal;
    @Widget(title="Min")
    private BigDecimal decimalMin;
    @Widget(title="Max")
    private BigDecimal decimalMax;
    @Widget(title="Default")
    private Integer defaultInteger;
    @Widget(title="Min")
    private Integer integerMin;
    @Widget(title="Max")
    private Integer integerMax;
    @Widget(title="Default")
    private String defaultString;
    @Widget(title="Large")
    private Boolean large = Boolean.FALSE;
    @Widget(title="Selection")
    @Index(name="META_FIELD_META_SELECT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaSelect metaSelect;
    @Widget(title="Reference Model")
    @Index(name="META_FIELD_META_MODEL_REF_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaModel metaModelRef;
    private Boolean readonly = Boolean.FALSE;
    private Boolean hidden = Boolean.FALSE;
    private Boolean required = Boolean.FALSE;
    private Boolean multiselect = Boolean.FALSE;
    @Widget(title="Sequence")
    private Integer sequence = 0;
    private Boolean customised = Boolean.FALSE;
    private Boolean existing = Boolean.FALSE;
    @Widget(title="Duration ?")
    private Boolean isDuration = Boolean.FALSE;
    @Widget(title="URL ?")
    private Boolean isUrl = Boolean.FALSE;
    @Widget(title="Help")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String helpText;
    @Widget(title="Track")
    private Boolean track = Boolean.FALSE;
    @Widget(title="Name column")
    private Boolean nameColumn = Boolean.FALSE;
    @Widget(title="Meta sequence")
    private String metaSequence;
    @Widget(title="Module")
    @Index(name="META_FIELD_META_MODULE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaModule metaModule;

    public MetaField() {
    }

    public MetaField(String name, Boolean nameColumn) {
        this.name = name;
        this.nameColumn = nameColumn;
    }

    public MetaModel getMetaModel() {
        return this.metaModel;
    }

    public void setMetaModel(MetaModel metaModel) {
        this.metaModel = metaModel;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getRelationship() {
        return this.relationship;
    }

    public void setRelationship(String relationship) {
        this.relationship = relationship;
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    public void setMappedBy(String mappedBy) {
        this.mappedBy = mappedBy;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<RightManagement> getRightManagementList() {
        return this.rightManagementList;
    }

    public void setRightManagementList(List<RightManagement> rightManagementList) {
        this.rightManagementList = rightManagementList;
    }

    public void addRightManagementListItem(RightManagement item) {
        if (this.rightManagementList == null) {
            this.rightManagementList = new ArrayList<RightManagement>();
        }
        this.rightManagementList.add(item);
        item.setMetaField(this);
    }

    public void removeRightManagementListItem(RightManagement item) {
        if (this.rightManagementList == null) {
            return;
        }
        this.rightManagementList.remove(item);
    }

    public void clearRightManagementList() {
        if (this.rightManagementList != null) {
            this.rightManagementList.clear();
        }
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public Boolean getDefaultBoolean() {
        return this.defaultBoolean;
    }

    public void setDefaultBoolean(Boolean defaultBoolean) {
        this.defaultBoolean = defaultBoolean;
    }

    public BigDecimal getDefaultDecimal() {
        return this.defaultDecimal;
    }

    public void setDefaultDecimal(BigDecimal defaultDecimal) {
        this.defaultDecimal = defaultDecimal;
    }

    public BigDecimal getDecimalMin() {
        return this.decimalMin;
    }

    public void setDecimalMin(BigDecimal decimalMin) {
        this.decimalMin = decimalMin;
    }

    public BigDecimal getDecimalMax() {
        return this.decimalMax;
    }

    public void setDecimalMax(BigDecimal decimalMax) {
        this.decimalMax = decimalMax;
    }

    public Integer getDefaultInteger() {
        return this.defaultInteger;
    }

    public void setDefaultInteger(Integer defaultInteger) {
        this.defaultInteger = defaultInteger;
    }

    public Integer getIntegerMin() {
        return this.integerMin;
    }

    public void setIntegerMin(Integer integerMin) {
        this.integerMin = integerMin;
    }

    public Integer getIntegerMax() {
        return this.integerMax;
    }

    public void setIntegerMax(Integer integerMax) {
        this.integerMax = integerMax;
    }

    public String getDefaultString() {
        return this.defaultString;
    }

    public void setDefaultString(String defaultString) {
        this.defaultString = defaultString;
    }

    public Boolean getLarge() {
        return this.large == null ? Boolean.FALSE : this.large;
    }

    public void setLarge(Boolean large) {
        this.large = large;
    }

    public MetaSelect getMetaSelect() {
        return this.metaSelect;
    }

    public void setMetaSelect(MetaSelect metaSelect) {
        this.metaSelect = metaSelect;
    }

    public MetaModel getMetaModelRef() {
        return this.metaModelRef;
    }

    public void setMetaModelRef(MetaModel metaModelRef) {
        this.metaModelRef = metaModelRef;
    }

    public Boolean getReadonly() {
        return this.readonly == null ? Boolean.FALSE : this.readonly;
    }

    public void setReadonly(Boolean readonly) {
        this.readonly = readonly;
    }

    public Boolean getHidden() {
        return this.hidden == null ? Boolean.FALSE : this.hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public Boolean getRequired() {
        return this.required == null ? Boolean.FALSE : this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public Boolean getMultiselect() {
        return this.multiselect == null ? Boolean.FALSE : this.multiselect;
    }

    public void setMultiselect(Boolean multiselect) {
        this.multiselect = multiselect;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public Boolean getCustomised() {
        return this.customised == null ? Boolean.FALSE : this.customised;
    }

    public void setCustomised(Boolean customised) {
        this.customised = customised;
    }

    public Boolean getExisting() {
        return this.existing == null ? Boolean.FALSE : this.existing;
    }

    public void setExisting(Boolean existing) {
        this.existing = existing;
    }

    public Boolean getIsDuration() {
        return this.isDuration == null ? Boolean.FALSE : this.isDuration;
    }

    public void setIsDuration(Boolean isDuration) {
        this.isDuration = isDuration;
    }

    public Boolean getIsUrl() {
        return this.isUrl == null ? Boolean.FALSE : this.isUrl;
    }

    public void setIsUrl(Boolean isUrl) {
        this.isUrl = isUrl;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    public Boolean getTrack() {
        return this.track == null ? Boolean.FALSE : this.track;
    }

    public void setTrack(Boolean track) {
        this.track = track;
    }

    public Boolean getNameColumn() {
        return this.nameColumn == null ? Boolean.FALSE : this.nameColumn;
    }

    public void setNameColumn(Boolean nameColumn) {
        this.nameColumn = nameColumn;
    }

    public String getMetaSequence() {
        return this.metaSequence;
    }

    public void setMetaSequence(String metaSequence) {
        this.metaSequence = metaSequence;
    }

    public MetaModule getMetaModule() {
        return this.metaModule;
    }

    public void setMetaModule(MetaModule metaModule) {
        this.metaModule = metaModule;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaField)) {
            return false;
        }
        MetaField other = (MetaField)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("name", (Object)this.getName());
        tsh.add("packageName", (Object)this.getPackageName());
        tsh.add("typeName", (Object)this.getTypeName());
        tsh.add("label", (Object)this.getLabel());
        tsh.add("relationship", (Object)this.getRelationship());
        tsh.add("mappedBy", (Object)this.getMappedBy());
        tsh.add("fieldType", (Object)this.getFieldType());
        tsh.add("defaultBoolean", (Object)this.getDefaultBoolean());
        tsh.add("defaultDecimal", (Object)this.getDefaultDecimal());
        tsh.add("decimalMin", (Object)this.getDecimalMin());
        tsh.add("decimalMax", (Object)this.getDecimalMax());
        return tsh.omitNullValues().toString();
    }
}

