/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.message.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.crm.db.Event;
import com.axelor.apps.message.db.EmailAddress;
import com.axelor.apps.message.db.MailAccount;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

@Entity
@Table(name="MESSAGE_MESSAGE")
public class Message
extends AuditableModel {
    @Widget(title="Type", help="true", readonly=true, selection="message.type.select")
    private Integer typeSelect = 2;
    @Widget(title="Subject")
    private String subject;
    @Widget(title="Content")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String content;
    @Widget(title="Sent date", help="true", readonly=true)
    private LocalDateTime sentDateT;
    @Widget(title="Forecasted Sent Date")
    private LocalDate sendScheduleDate;
    @Widget(title="Related to", selection="message.related.to.select")
    private String relatedTo1Select;
    private Integer relatedTo1SelectId = 0;
    @Widget(title="Related to", selection="message.related.to.select")
    private String relatedTo2Select;
    private Integer relatedTo2SelectId = 0;
    @Widget(title="Status", readonly=true, selection="message.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Media Type", help="true", selection="message.media.type.select")
    private Integer mediaTypeSelect = 0;
    @Widget(title="Address Block", help="true", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    private String addressBlock;
    @Widget(title="From")
    @Index(name="MESSAGE_MESSAGE_FROM_EMAIL_ADDRESS_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EmailAddress fromEmailAddress;
    @Widget(title="Reply to")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<EmailAddress> replyToEmailAddressSet;
    @Widget(title="To")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<EmailAddress> toEmailAddressSet;
    @Widget(title="Cc", help="true")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<EmailAddress> ccEmailAddressSet;
    @Widget(title="Bcc", help="true")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<EmailAddress> bccEmailAddressSet;
    @Widget(title="Sent by email")
    private Boolean sentByEmail = Boolean.FALSE;
    @Widget(title="Mail account")
    @Index(name="MESSAGE_MESSAGE_MAIL_ACCOUNT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MailAccount mailAccount;
    @Widget(title="Sender (User)", readonly=true)
    @Index(name="MESSAGE_MESSAGE_SENDER_USER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User senderUser;
    @Widget(title="Recipient")
    @Index(name="MESSAGE_MESSAGE_RECIPIENT_USER_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User recipientUser;
    @Widget(title="Company", help="true")
    @Index(name="MESSAGE_MESSAGE_COMPANY_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="MESSAGE_MESSAGE_SEQ")
    @SequenceGenerator(name="MESSAGE_MESSAGE_SEQ", sequenceName="MESSAGE_MESSAGE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Event")
    @Index(name="MESSAGE_MESSAGE_EVENT_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Event event;

    public Message() {
    }

    public Message(Integer typeSelect, String subject, String content, Integer statusSelect, Integer mediaTypeSelect, String addressBlock, EmailAddress fromEmailAddress, Set<EmailAddress> replyToEmailAddressSet, Set<EmailAddress> toEmailAddressSet, Set<EmailAddress> ccEmailAddressSet, Set<EmailAddress> bccEmailAddressSet, Boolean sentByEmail, MailAccount mailAccount) {
        this.typeSelect = typeSelect;
        this.subject = subject;
        this.content = content;
        this.statusSelect = statusSelect;
        this.mediaTypeSelect = mediaTypeSelect;
        this.addressBlock = addressBlock;
        this.fromEmailAddress = fromEmailAddress;
        this.replyToEmailAddressSet = replyToEmailAddressSet;
        this.toEmailAddressSet = toEmailAddressSet;
        this.ccEmailAddressSet = ccEmailAddressSet;
        this.bccEmailAddressSet = bccEmailAddressSet;
        this.sentByEmail = sentByEmail;
        this.mailAccount = mailAccount;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public LocalDateTime getSentDateT() {
        return this.sentDateT;
    }

    public void setSentDateT(LocalDateTime sentDateT) {
        this.sentDateT = sentDateT;
    }

    public LocalDate getSendScheduleDate() {
        return this.sendScheduleDate;
    }

    public void setSendScheduleDate(LocalDate sendScheduleDate) {
        this.sendScheduleDate = sendScheduleDate;
    }

    public String getRelatedTo1Select() {
        return this.relatedTo1Select;
    }

    public void setRelatedTo1Select(String relatedTo1Select) {
        this.relatedTo1Select = relatedTo1Select;
    }

    public Integer getRelatedTo1SelectId() {
        return this.relatedTo1SelectId == null ? 0 : this.relatedTo1SelectId;
    }

    public void setRelatedTo1SelectId(Integer relatedTo1SelectId) {
        this.relatedTo1SelectId = relatedTo1SelectId;
    }

    public String getRelatedTo2Select() {
        return this.relatedTo2Select;
    }

    public void setRelatedTo2Select(String relatedTo2Select) {
        this.relatedTo2Select = relatedTo2Select;
    }

    public Integer getRelatedTo2SelectId() {
        return this.relatedTo2SelectId == null ? 0 : this.relatedTo2SelectId;
    }

    public void setRelatedTo2SelectId(Integer relatedTo2SelectId) {
        this.relatedTo2SelectId = relatedTo2SelectId;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Integer getMediaTypeSelect() {
        return this.mediaTypeSelect == null ? 0 : this.mediaTypeSelect;
    }

    public void setMediaTypeSelect(Integer mediaTypeSelect) {
        this.mediaTypeSelect = mediaTypeSelect;
    }

    public String getAddressBlock() {
        return this.addressBlock;
    }

    public void setAddressBlock(String addressBlock) {
        this.addressBlock = addressBlock;
    }

    public EmailAddress getFromEmailAddress() {
        return this.fromEmailAddress;
    }

    public void setFromEmailAddress(EmailAddress fromEmailAddress) {
        this.fromEmailAddress = fromEmailAddress;
    }

    public Set<EmailAddress> getReplyToEmailAddressSet() {
        return this.replyToEmailAddressSet;
    }

    public void setReplyToEmailAddressSet(Set<EmailAddress> replyToEmailAddressSet) {
        this.replyToEmailAddressSet = replyToEmailAddressSet;
    }

    public void addReplyToEmailAddressSetItem(EmailAddress item) {
        if (this.replyToEmailAddressSet == null) {
            this.replyToEmailAddressSet = new HashSet<EmailAddress>();
        }
        this.replyToEmailAddressSet.add(item);
    }

    public void removeReplyToEmailAddressSetItem(EmailAddress item) {
        if (this.replyToEmailAddressSet == null) {
            return;
        }
        this.replyToEmailAddressSet.remove((Object)item);
    }

    public void clearReplyToEmailAddressSet() {
        if (this.replyToEmailAddressSet != null) {
            this.replyToEmailAddressSet.clear();
        }
    }

    public Set<EmailAddress> getToEmailAddressSet() {
        return this.toEmailAddressSet;
    }

    public void setToEmailAddressSet(Set<EmailAddress> toEmailAddressSet) {
        this.toEmailAddressSet = toEmailAddressSet;
    }

    public void addToEmailAddressSetItem(EmailAddress item) {
        if (this.toEmailAddressSet == null) {
            this.toEmailAddressSet = new HashSet<EmailAddress>();
        }
        this.toEmailAddressSet.add(item);
    }

    public void removeToEmailAddressSetItem(EmailAddress item) {
        if (this.toEmailAddressSet == null) {
            return;
        }
        this.toEmailAddressSet.remove((Object)item);
    }

    public void clearToEmailAddressSet() {
        if (this.toEmailAddressSet != null) {
            this.toEmailAddressSet.clear();
        }
    }

    public Set<EmailAddress> getCcEmailAddressSet() {
        return this.ccEmailAddressSet;
    }

    public void setCcEmailAddressSet(Set<EmailAddress> ccEmailAddressSet) {
        this.ccEmailAddressSet = ccEmailAddressSet;
    }

    public void addCcEmailAddressSetItem(EmailAddress item) {
        if (this.ccEmailAddressSet == null) {
            this.ccEmailAddressSet = new HashSet<EmailAddress>();
        }
        this.ccEmailAddressSet.add(item);
    }

    public void removeCcEmailAddressSetItem(EmailAddress item) {
        if (this.ccEmailAddressSet == null) {
            return;
        }
        this.ccEmailAddressSet.remove((Object)item);
    }

    public void clearCcEmailAddressSet() {
        if (this.ccEmailAddressSet != null) {
            this.ccEmailAddressSet.clear();
        }
    }

    public Set<EmailAddress> getBccEmailAddressSet() {
        return this.bccEmailAddressSet;
    }

    public void setBccEmailAddressSet(Set<EmailAddress> bccEmailAddressSet) {
        this.bccEmailAddressSet = bccEmailAddressSet;
    }

    public void addBccEmailAddressSetItem(EmailAddress item) {
        if (this.bccEmailAddressSet == null) {
            this.bccEmailAddressSet = new HashSet<EmailAddress>();
        }
        this.bccEmailAddressSet.add(item);
    }

    public void removeBccEmailAddressSetItem(EmailAddress item) {
        if (this.bccEmailAddressSet == null) {
            return;
        }
        this.bccEmailAddressSet.remove((Object)item);
    }

    public void clearBccEmailAddressSet() {
        if (this.bccEmailAddressSet != null) {
            this.bccEmailAddressSet.clear();
        }
    }

    public Boolean getSentByEmail() {
        return this.sentByEmail == null ? Boolean.FALSE : this.sentByEmail;
    }

    public void setSentByEmail(Boolean sentByEmail) {
        this.sentByEmail = sentByEmail;
    }

    public MailAccount getMailAccount() {
        return this.mailAccount;
    }

    public void setMailAccount(MailAccount mailAccount) {
        this.mailAccount = mailAccount;
    }

    public User getSenderUser() {
        return this.senderUser;
    }

    public void setSenderUser(User senderUser) {
        this.senderUser = senderUser;
    }

    public User getRecipientUser() {
        return this.recipientUser;
    }

    public void setRecipientUser(User recipientUser) {
        this.recipientUser = recipientUser;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("typeSelect", (Object)this.getTypeSelect());
        tsh.add("subject", (Object)this.getSubject());
        tsh.add("sentDateT", (Object)this.getSentDateT());
        tsh.add("sendScheduleDate", (Object)this.getSendScheduleDate());
        tsh.add("relatedTo1Select", (Object)this.getRelatedTo1Select());
        tsh.add("relatedTo1SelectId", (Object)this.getRelatedTo1SelectId());
        tsh.add("relatedTo2Select", (Object)this.getRelatedTo2Select());
        tsh.add("relatedTo2SelectId", (Object)this.getRelatedTo2SelectId());
        tsh.add("statusSelect", (Object)this.getStatusSelect());
        tsh.add("mediaTypeSelect", (Object)this.getMediaTypeSelect());
        tsh.add("sentByEmail", (Object)this.getSentByEmail());
        return tsh.omitNullValues().toString();
    }
}

