/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.marketing.service;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.crm.db.Lead;
import com.axelor.apps.marketing.db.Campaign;
import com.axelor.apps.marketing.db.TargetList;
import com.axelor.apps.marketing.service.CampaignService;
import com.axelor.apps.message.db.Template;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.mail.MessagingException;

public class CampaignServiceImpl
implements CampaignService {
    @Inject
    private TemplateMessageService templateMessageService;
    @Inject
    private MetaFiles metaFiles;

    @Override
    public MetaFile sendEmail(Campaign campaign) {
        String errorPartners = "";
        String errorLeads = "";
        for (TargetList target : campaign.getTargetListSet()) {
            errorPartners = this.sendToPartners(target.getPartnerSet(), campaign.getPartnerTemplate());
            errorLeads = this.sendToLeads(target.getLeadSet(), campaign.getLeadTemplate());
        }
        if (errorPartners.isEmpty() && errorLeads.isEmpty()) {
            return null;
        }
        return this.generateLog(errorPartners, errorLeads, campaign.getEmailLog(), campaign.getId());
    }

    private String sendToPartners(Set<Partner> partnerSet, Template template) {
        StringBuilder errors = new StringBuilder();
        for (Partner partner : partnerSet) {
            try {
                this.templateMessageService.generateAndSendMessage((Model)partner, template);
            }
            catch (AxelorException | IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | MessagingException e) {
                errors.append(partner.getName() + "\n");
                e.printStackTrace();
            }
        }
        return errors.toString();
    }

    private String sendToLeads(Set<Lead> leadSet, Template template) {
        StringBuilder errors = new StringBuilder();
        for (Lead lead : leadSet) {
            try {
                this.templateMessageService.generateAndSendMessage((Model)lead, template);
            }
            catch (AxelorException | IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | MessagingException e) {
                errors.append(lead.getName() + "\n");
                e.printStackTrace();
            }
        }
        return errors.toString();
    }

    private MetaFile generateLog(String errorPartners, String errorLeads, MetaFile metaFile, Long campaignId) {
        if (metaFile == null) {
            metaFile = new MetaFile();
            metaFile.setFileName("EmailLog" + campaignId + ".text");
        }
        StringBuilder builder = new StringBuilder();
        builder.append(I18n.get((String)"Error in sending an email to the following targets"));
        builder.append("\n");
        if (!errorPartners.isEmpty()) {
            builder.append("Partners:\n");
            builder.append(errorPartners);
        }
        if (!errorLeads.isEmpty()) {
            builder.append("Leads:\n");
            builder.append(errorLeads);
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(builder.toString().getBytes());
        try {
            return this.metaFiles.upload((InputStream)stream, metaFile.getFileName());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

