/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.marketing.db;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.crm.db.Lead;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.studio.db.Filter;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Index;

@Entity
@Table(name="MARKETING_TARGET_LIST")
public class TargetList
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="MARKETING_TARGET_LIST_SEQ")
    @SequenceGenerator(name="MARKETING_TARGET_LIST_SEQ", sequenceName="MARKETING_TARGET_LIST_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    @Index(name="MARKETING_TARGET_LIST_NAME_IDX")
    private String name;
    @Widget(title="Partner filters")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<Filter> partnerFilterList;
    @Widget(title="Select type", selection="target.partner.type.select")
    private Integer partnerTypeSelect = 0;
    @Widget(title="Select Partner/Contacts")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Partner> partnerSet;
    @Widget(title="Lead filters")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<Filter> leadFilterList;
    @Widget(title="Select leads")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Lead> leadSet;

    public TargetList() {
    }

    public TargetList(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Filter> getPartnerFilterList() {
        return this.partnerFilterList;
    }

    public void setPartnerFilterList(List<Filter> partnerFilterList) {
        this.partnerFilterList = partnerFilterList;
    }

    public void addPartnerFilterListItem(Filter item) {
        if (this.partnerFilterList == null) {
            this.partnerFilterList = new ArrayList<Filter>();
        }
        this.partnerFilterList.add(item);
    }

    public void removePartnerFilterListItem(Filter item) {
        if (this.partnerFilterList == null) {
            return;
        }
        this.partnerFilterList.remove(item);
    }

    public void clearPartnerFilterList() {
        if (this.partnerFilterList != null) {
            this.partnerFilterList.clear();
        }
    }

    public Integer getPartnerTypeSelect() {
        return this.partnerTypeSelect == null ? 0 : this.partnerTypeSelect;
    }

    public void setPartnerTypeSelect(Integer partnerTypeSelect) {
        this.partnerTypeSelect = partnerTypeSelect;
    }

    public Set<Partner> getPartnerSet() {
        return this.partnerSet;
    }

    public void setPartnerSet(Set<Partner> partnerSet) {
        this.partnerSet = partnerSet;
    }

    public void addPartnerSetItem(Partner item) {
        if (this.partnerSet == null) {
            this.partnerSet = new HashSet<Partner>();
        }
        this.partnerSet.add(item);
    }

    public void removePartnerSetItem(Partner item) {
        if (this.partnerSet == null) {
            return;
        }
        this.partnerSet.remove(item);
    }

    public void clearPartnerSet() {
        if (this.partnerSet != null) {
            this.partnerSet.clear();
        }
    }

    public List<Filter> getLeadFilterList() {
        return this.leadFilterList;
    }

    public void setLeadFilterList(List<Filter> leadFilterList) {
        this.leadFilterList = leadFilterList;
    }

    public void addLeadFilterListItem(Filter item) {
        if (this.leadFilterList == null) {
            this.leadFilterList = new ArrayList<Filter>();
        }
        this.leadFilterList.add(item);
    }

    public void removeLeadFilterListItem(Filter item) {
        if (this.leadFilterList == null) {
            return;
        }
        this.leadFilterList.remove(item);
    }

    public void clearLeadFilterList() {
        if (this.leadFilterList != null) {
            this.leadFilterList.clear();
        }
    }

    public Set<Lead> getLeadSet() {
        return this.leadSet;
    }

    public void setLeadSet(Set<Lead> leadSet) {
        this.leadSet = leadSet;
    }

    public void addLeadSetItem(Lead item) {
        if (this.leadSet == null) {
            this.leadSet = new HashSet<Lead>();
        }
        this.leadSet.add(item);
    }

    public void removeLeadSetItem(Lead item) {
        if (this.leadSet == null) {
            return;
        }
        this.leadSet.remove(item);
    }

    public void clearLeadSet() {
        if (this.leadSet != null) {
            this.leadSet.clear();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TargetList)) {
            return false;
        }
        TargetList other = (TargetList)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("name", (Object)this.getName());
        tsh.add("partnerTypeSelect", (Object)this.getPartnerTypeSelect());
        return tsh.omitNullValues().toString();
    }
}

