/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.marketing.db;

import com.axelor.apps.marketing.db.TargetList;
import com.axelor.apps.message.db.Template;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Index;

@Entity
@Table(name="MARKETING_CAMPAIGN")
public class Campaign
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="MARKETING_CAMPAIGN_SEQ")
    @SequenceGenerator(name="MARKETING_CAMPAIGN_SEQ", sequenceName="MARKETING_CAMPAIGN_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    @Index(name="MARKETING_CAMPAIGN_NAME_IDX")
    private String name;
    @Widget(title="Stage", selection="campaign.stage.select")
    private Integer stageSelect = 0;
    @Widget(title="Targets")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<TargetList> targetListSet;
    @Widget(title="Contact/Partners template")
    @Index(name="MARKETING_CAMPAIGN_PARTNER_TEMPLATE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template partnerTemplate;
    @Widget(title="Leads template")
    @Index(name="MARKETING_CAMPAIGN_LEAD_TEMPLATE_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template leadTemplate;
    @Widget(title="Email sending log")
    @Index(name="MARKETING_CAMPAIGN_EMAIL_LOG_IDX")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile emailLog;

    public Campaign() {
    }

    public Campaign(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getStageSelect() {
        return this.stageSelect == null ? 0 : this.stageSelect;
    }

    public void setStageSelect(Integer stageSelect) {
        this.stageSelect = stageSelect;
    }

    public Set<TargetList> getTargetListSet() {
        return this.targetListSet;
    }

    public void setTargetListSet(Set<TargetList> targetListSet) {
        this.targetListSet = targetListSet;
    }

    public void addTargetListSetItem(TargetList item) {
        if (this.targetListSet == null) {
            this.targetListSet = new HashSet<TargetList>();
        }
        this.targetListSet.add(item);
    }

    public void removeTargetListSetItem(TargetList item) {
        if (this.targetListSet == null) {
            return;
        }
        this.targetListSet.remove((Object)item);
    }

    public void clearTargetListSet() {
        if (this.targetListSet != null) {
            this.targetListSet.clear();
        }
    }

    public Template getPartnerTemplate() {
        return this.partnerTemplate;
    }

    public void setPartnerTemplate(Template partnerTemplate) {
        this.partnerTemplate = partnerTemplate;
    }

    public Template getLeadTemplate() {
        return this.leadTemplate;
    }

    public void setLeadTemplate(Template leadTemplate) {
        this.leadTemplate = leadTemplate;
    }

    public MetaFile getEmailLog() {
        return this.emailLog;
    }

    public void setEmailLog(MetaFile emailLog) {
        this.emailLog = emailLog;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Campaign)) {
            return false;
        }
        Campaign other = (Campaign)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)((Object)this));
        tsh.add("id", (Object)this.getId());
        tsh.add("name", (Object)this.getName());
        tsh.add("stageSelect", (Object)this.getStageSelect());
        return tsh.omitNullValues().toString();
    }
}

